**********************************************************************************************
* Do-file used to impute savings accounts based on wealth wealth surveys  *
***********************************************************************************************

* Imputation based on age groups.groups of financial income.groups of labor income

/*
Notes: 
* For the wealth suvreys 1986, 1992 and 1998, there is no allocation of financial assets by member of the household. Only available for the entiere household
* We use the share of savings account owned by the couples vs dependents of 2004 for previous years 
*/

* I) Organize the data
***************************

	* Load the data
		use "$wfpat/wfEP04.dta",clear
		append using "$wfpat/wfEP10.dta"
		append using "$wfpat/wfEP98.dta"
		append using "$wfpat/wfEP92.dta"
		append using "$wfpat/wfEP92.dta"
		append using "$wfpat/wfEP86.dta"

	
	* Variables used for imputations
		
		* Labor income (self-employed income + wages + replacement income)
			gen lr_irpp_foy = rev_act_pens  

		* Age groups
			capture drop q_age_pr
			gen q_age_pr = 1
			replace q_age_pr = 2 if age >30
			replace q_age_pr = 3 if age >39
			replace q_age_pr = 4 if age >49
			replace q_age_pr = 5 if age >54
			replace q_age_pr = 6 if age >60
			replace q_age_pr = 7 if age >65
			replace q_age_pr = 8 if age >70
			*tab q_age_pr

		* Age.groups of financial income
			sort year q_age_pr rfin_irpp_foy id_men
			gen u=uniform()
			replace rfin_irpp_foy=u if rfin_irpp_foy==0
			
			gen pondvr=round(100*pondn) 
			bys year q_age_pr : cumul rfin_irpp_foy [w=pondvr], gen (p100)
			replace p100=p100*100
			gen q_age_fin   = 0
			replace q_age_fin= 50   if p100 >=50 & p100 <75 & q_age_fin==0
			replace q_age_fin= 75   if p100 >=75 & p100 <90 & q_age_fin==0
			replace q_age_fin= 90   if p100 >=90 & p100 <95 & q_age_fin==0
			replace q_age_fin= 95   if p100 >=95  & q_age_fin==0
			drop p100  pondvr u
		
		* Age.groups of financial income.groups of labor income.
			capture drop q_age_fin_lr
			sort year q_age_pr q_age_fin lr_irpp_foy id_men

			gen u=13*uniform()
			replace lr_irpp_foy=u if lr_irpp_foy==0
		    
			gen pondvr=round(100*pondn) 
			bys year q_age_pr q_age_fin  :  cumul lr_irpp_foy [w=pondvr], gen (p100)
			replace p100=p100*100
			gen q_age_fin_lr  = 0
			replace q_age_fin_lr=25  if p100 >=25 & p100 <50 & q_age_fin_lr==0
			replace q_age_fin_lr= 50   if p100 >=50 & p100 <75 & q_age_fin_lr==0
			replace q_age_fin_lr= 75   if p100 >=75 & p100 <90 & q_age_fin_lr==0
			replace q_age_fin_lr= 90   if p100 >=90 & p100 <95 & q_age_fin_lr==0
			replace q_age_fin_lr= 95   if p100 >=95 & q_age_fin_lr==0
			* Adjusment for the top 5% of financial income (not enough observation to split into labor income)
				replace q_age_fin_lr= 0   if q_age_fin== 95
				drop  p100 pondvr
			


* II) Statistics for the imputation
*************************************
	
	* Savings accounts excluding deposits
		gen patfin_liqu_noncc= max(0,patfin_liqu-ccheque)
		gen prop_patfin_liqu_noncc=pondn* (patfin_liqu_noncc>0)
		drop patfin_liqu_noncc
		
	* Everybody has savings accounts and deposits
		gen prop_patfin_liqu=pondn
		
	* Savings account and deposits for household with dependents for year >2004
		gen patfin_liqu_pac_tot=patfin_liqu*(pac_adult==1)
	
	* Weighted amounts
		foreach var of varlist  patfin_liqu  patfin_liqu_pac patfin_liqu_pac_tot {
			replace `var'=`var'*pondn
		}
		
	tempfile temp
	save "`temp'", replace	
	collapse (sum) tot=pondn  patfin_liqu patfin_liqu_pac_tot patfin_liqu_pac prop_patfin_liqu  prop_patfin_liqu_noncc,by(year q_age_pr q_age_fin q_age_fin_lr)
	
	* Ownership of savings accounts (prop_patfin_liqu_noncc), Savings accounts + deposits (prop_patfin_liqu)
		foreach var of varlist prop_patfin_liqu  prop_patfin_liqu_noncc {
			replace `var'=`var'/tot
		}
		tempfile temp2
		save "`temp2'", replace
	
	* Share of savings accounts and deposits accruing to dependents (share_patfin_liqu_pac)
		use "`temp'",clear
		collapse (sum) patfin_liqu_pac_tot patfin_liqu_pac ,by(year q_age_pr q_age_fin)
		gen share_patfin_liqu_pac=patfin_liqu_pac/patfin_liqu_pac_tot
		drop patfin_liqu_pac_tot patfin_liqu_pac 
		merge 1:m year q_age_pr q_age_fin using "`temp2'"
		drop patfin_liqu_pac_tot patfin_liqu_pac _merge
	
	* Share of total savings accounts and deposits accruing to each group (share_patfin_liqu)
		bys year: egen patfin_liqu_tot=sum(patfin_liq) 
		gen share_patfin_liqu=100*patfin_liqu/patfin_liqu_tot
		/* Memo: Average savings accounts and deposits by groups
		gen patfin_liqu_mean=patfin_liqu/tot */


	keep year q* share* prop* share*
	
* III) Harmonization and correction
*************************************

	* Share of deposits and savings accounts accruing to dependents missing for some groups in 2004 and 2010 and completely for years 1986, 1992 and 1998
		sort year q_age_pr q_age_fin q_age_fin_lr
		replace share_patfin_liqu_pac=0 if q_age_pr==1
		* For year 2010
		replace share_patfin_liqu_pac=(share_patfin_liqu_pac[_n-6] + share_patfin_liqu_pac[850])/2 if (q_age_pr==2 & q_age_fin==90) & year ==2010
		replace share_patfin_liqu_pac=(share_patfin_liqu_pac[_n-6] + share_patfin_liqu_pac[875])/2 if (q_age_pr==3 & q_age_fin==90) & year ==2010
		replace share_patfin_liqu_pac=(share_patfin_liqu_pac[_n-6] + share_patfin_liqu_pac[900])/2 if (q_age_pr==4 & q_age_fin==90) & year ==2010
		replace share_patfin_liqu_pac=(share_patfin_liqu_pac[_n-6] + share_patfin_liqu_pac[950])/2 if (q_age_pr==6 & q_age_fin==90) & year ==2010
		replace share_patfin_liqu_pac=share_patfin_liqu_pac[_n-25] if q_age_pr>=7 & year==2010

		* For year 2004
		replace share_patfin_liqu_pac=share_patfin_liqu_pac[_n+25] if (q_age_pr==2) & q_age_fin>=75 & year ==2004
		replace share_patfin_liqu_pac=share_patfin_liqu_pac[_n-25]  if (q_age_pr==6 & q_age_fin==95) & year ==2004
		replace share_patfin_liqu_pac=(share_patfin_liqu_pac[_n-6] + share_patfin_liqu_pac[750])/2 if (q_age_pr==6 & q_age_fin==90) & year ==2004	
		replace share_patfin_liqu_pac=share_patfin_liqu_pac[_n-25] if q_age_pr>=7 & year==2004

		* For years 1992 and 1998 
			replace share_patfin_liqu_pac=share_patfin_liqu_pac[_n+200] if year==1998
			replace share_patfin_liqu_pac=share_patfin_liqu_pac[_n+200] if year==1992
			replace share_patfin_liqu_pac=share_patfin_liqu_pac[_n+200] if year==1986

	tempfile base
	save "`base'",replace

	* Interpolation for missing years
		
		* Add missing years
		keep if year==1998
		foreach var of varlist year prop_patfin_liqu_noncc prop_patfin_liqu share_patfin_liqu_pac share_patfin_liqu  {
			replace `var'=.
		}
		tempfile temp
		save "`temp'",replace
		use "`base'",clear
		foreach num of numlist 1987/1991 1993/1997 1999/2003 2005/2009 {
			append using "`temp'"
			replace year=`num' if year==.
		}
		sort year
		
		* Years 1986, 1992, 1998, 2004 and 2010
		erase "`temp'"
		erase "`base'"
		tempfile newbase
		save "`newbase'",replace
		tempfile temp
		save "`temp'",replace
		foreach num of numlist 1986 1992 1998 2004 2010 {
			use "`temp'",clear
			keep if year==`num'
			foreach var of varlist  prop_patfin_liqu_noncc prop_patfin_liqu  share_patfin_liqu share_patfin_liqu_pac {
				rename `var' `var'`num'
			}
			drop year
			merge m:m q_age_pr q_age_fin q_age_fin_lr using "`newbase'"
			drop _merge
			erase "`newbase'"
			tempfile newbase
			save "`newbase'",replace
		}
		erase "`temp'"
		sort year q_age_pr q_age_fin q_age_fin_lr
	
	* Interpolation
	
		* Period 1987-1991
			local i =1986
			local j=1992
			foreach var of varlist  prop_patfin_liqu_noncc prop_patfin_liqu  share_patfin_liqu share_patfin_liqu_pac    {
				replace `var'=`var'`i'+(`var'`j' -`var'`i')*(year-`i')/(`j'- `i') if year>`i' & year< `j'
			}
			
		* Period 1993-1997
			local i =1992
			local j=1998
			foreach var of varlist  prop_patfin_liqu_noncc prop_patfin_liqu  share_patfin_liqu share_patfin_liqu_pac    {
				replace `var'=`var'`i'+(`var'`j' -`var'`i')*(year-`i')/(`j'- `i') if year>`i' & year< `j'
			}
			
		* Period 1999-2003
			local i =1998
			local j=2004
			foreach var of varlist  prop_patfin_liqu_noncc prop_patfin_liqu  share_patfin_liqu share_patfin_liqu_pac    {
				replace `var'=`var'`i'+(`var'`j' -`var'`i')*(year-`i')/(`j'- `i') if year>`i' & year< `j'
			}
			
		* Period 2005-2009
			local i =2004
			local j=2010
			foreach var of varlist  prop_patfin_liqu_noncc prop_patfin_liqu  share_patfin_liqu  share_patfin_liqu_pac  {
				replace `var'=`var'`i'+(`var'`j' -`var'`i')*(year-`i')/(`j'- `i') if year>`i' & year< `j'
			}
			drop *2010 *2004 *1998 *1992 *1986
			order year q_age_pr q_age_fin q_age_fin_lr
			sort year q_age_pr q_age_fin q_age_fin_lr
			
save "$param/Imputation/clef_liqu_EP.dta",replace			


